IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Clientes_Visitas') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Clientes_Visitas
END
GO

CREATE PROCEDURE [dbo].[CPJ_Clientes_Visitas] @pJsonRecibido VARCHAR(MAX)
AS
SET NOCOUNT ON

	IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Clientes_Visitas_') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
	BEGIN 
		EXEC CPJ_Clientes_Visitas_ @pJsonRecibido
		RETURN
	END	

	/***************************************************************************************************

	Procedimiento:      CPJ_Clientes_Visitas
	Fecha de Creacion:  2024-10-22
	Creado por:         Adriana Laverde
	Descripcion:        Stored creado para generar invitaciones al club
	Llamado por:        invitados.php (KIOSK, APP)
	Tablas afectadas:   []
	Usado en:           
	Parametro(s):       FlagUsarTrans, ModoDebug, 
	Forma de uso:       EXEC
	Notas adicionales:  Usar CPJ_Clientes_Visitas_ para validaciones particulares

	****************************************************************************************************

	SUMARIO DE CAMBIOS
	FECHA(yyyy-mm-dd)    Autor              Comentarios
	------------------- ------------------- ------------------------------------------------------------

              
	***************************************************************************************************/

/*Variables recibidas por parametro a traves del JSON*/
DECLARE	@pFlagUsarTrans			TINYINT,
		@pModoDebug				TINYINT,
		@pApellido				VARCHAR(100),
		@pNombre				VARCHAR(100),
		@pDocumento				VARCHAR(100),
		@pFecha_Invitacion		DATETIME,
		@pCantidad				INT,
        @pEmail					VARCHAR(100),
		@pObservacion			VARCHAR(2000),
		@pId_Invitante			INT,
		@pTipo					TINYINT,
		@pId_Link				INT

SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'ModoDebug')), 0)
SET @pApellido					= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJsonRecibido,'Apellido')), '')
SET @pNombre					= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJsonRecibido,'Nombre')), '')
SET @pDocumento					= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJsonRecibido,'Documento')),'')
SET @pFecha_Invitacion			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Invitacion')),'')
SET @pCantidad					= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Cantidad')),'')
SET @pEmail						= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJsonRecibido,'Email')),'')
SET @pObservacion				= ISNULL(CONVERT(VARCHAR(2000), dbo.CF_JSON_VALUE(@pJsonRecibido,'Observacion')),'')
SET @pId_Invitante				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Invitante')),0)
SET @pTipo						= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Tipo')),0)
SET @pId_Link					= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Link')),0) -- Para los registros de invitados por link
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored			INT
DECLARE @rtaMsjStored			VARCHAR(4000)
/*FIN Variable de Retorono del Stored*/

/*Variables Locales*/
DECLARE @Invitacion_Previa			DATETIME
DECLARE @Existe						INT = 0
DECLARE @Cant_Invitaciones			INT
DECLARE @Categoria					INT
DECLARE @Categoria_Invitado			INT
DECLARE @Cant_Visitas_En_Mes		INT
DECLARE @Primer_Dia_Mes				DATETIME
DECLARE @Primer_Dia_Prox_Mes		DATETIME
DECLARE @Fecha_Libre				DATETIME = 0 --Libre de validaciones 
DECLARE	@URL						VARCHAR(2000)
DECLARE @Token						VARCHAR(250)
/*FINVariables Locales*/

BEGIN TRY
	IF (@pFlagUsarTrans <> 0)
	BEGIN
		BEGIN TRAN
	END

	IF (@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Clientes_Visitas'
		PRINT 'Parametros: '+ @pJsonRecibido  
		PRINT ' ---------------------- '
	END

	IF(@pId_Link > 0)
	BEGIN
		SET @pId_Invitante = ISNULL((SELECT Id_Cliente FROM Clientes_Links WHERE Id_Link = @pId_Link),0)
		SET @pFecha_Invitacion = ISNULL((SELECT Fecha_Desde FROM Clientes_Links WHERE Id_Link = @pId_Link),'')
	END
	ELSE
	BEGIN
	 SET @pId_Link = NULL
	END

	IF(@pTipo = 1)
	BEGIN
		-----------------------------------------------------------------------------------------------
		SET	@Existe				= ISNULL((SELECT MAX(Id_Cliente) FROM Clientes WHERE Doc_Nro = CAST(@pDocumento AS BIGINT) AND Activo = 1),0)
		SET	@Categoria			= ISNULL((SELECT TOP 1 Id_Tipo_Cli FROM Clientes WHERE Id_Cliente = @Existe AND Activo = 1),0)

		SET @Categoria_Invitado = dbo.CF_xParam('Categ_Invitados')
		----------------------------------------------------

		SET @Primer_Dia_Mes = (dbo.CF_FOMONTH(@pFecha_Invitacion))
		SET @Primer_Dia_Prox_Mes = DATEADD(MONTH, 1, @Primer_Dia_Mes) 
		SET @Cant_Visitas_En_Mes = ISNULL((SELECT COUNT(*) 
												FROM CD_ES
												WHERE
												Id_Cliente = @Existe
												AND Fecha >= @Primer_Dia_Mes
												AND Fecha < @Primer_Dia_Prox_Mes)
											,0)
		----------------------------------------------------

		SET @Invitacion_Previa = (SELECT ISNULL((SELECT MAX(Fecha)
			FROM Clientes_Invitados_Mov 
			WHERE Id_Cliente_D = @Existe	
			AND FECHA >= DATEADD(yy, DATEDIFF(yy, 0, GETDATE()), 0)
			AND FECHA <=  DATEADD(yy, DATEDIFF(yy, 0, GETDATE()) + 1, -1)),'19000101'))
		----------------------------------------------------

		SELECT @Cant_Invitaciones = COUNT(*)
			FROM Clientes_Invitados_Mov 
			WHERE Id_Cliente_D = @Existe 
			AND FECHA >= DATEADD(yy, DATEDIFF(yy, 0, GETDATE()), 0)
			AND FECHA <=  DATEADD(yy, DATEDIFF(yy, 0, GETDATE()) + 1, -1)
		----------------------------------------------------
	END

	IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES 
			   WHERE TABLE_NAME = 'zInvit_Fechas_Libres' 
			   AND TABLE_SCHEMA = 'dbo')
	BEGIN
		SET @Fecha_Libre = (SELECT ISNULL((SELECT 1
										   FROM zInvit_Fechas_Libres 
										   WHERE Fecha_Desde <= @pFecha_Invitacion
										   AND Fecha_Hasta >= @pFecha_Invitacion), 0))
	END

	----------------------------------------------------

	IF (ISNULL(@Existe,0 ) <> 0)
	BEGIN
	
		IF(@Categoria NOT IN (@Categoria_Invitado))
			BEGIN
				SELECT  5001 AS ErrorNumber
					,1 AS ErrorSeverity
					,1 AS ErrorState
					,1 AS ErrorProcedure
					,1 AS ErrorLine
					,'No es posible realizar la invitación a un Socio.' AS ErrorMessage
			RETURN 9999
			END

		IF(@Fecha_Libre = 0) --(0: VALIDA ; 1: NO VALIDA (LIBRE))
		BEGIN

			IF(@Cant_Invitaciones >= dbo.CF_xParam('Invit_Max_Anuales'))
			BEGIN
				SELECT  5001 AS ErrorNumber
					,1 AS ErrorSeverity
					,1 AS ErrorState
					,1 AS ErrorProcedure
					,1 AS ErrorLine
					,'No es posible realizar la invitación. La persona posee el máximo de invitaciones en el año.' AS ErrorMessage
			RETURN 9999
			END

			IF(@pFecha_Invitacion < @Invitacion_Previa)
			BEGIN
				SELECT  5001 AS ErrorNumber
					,1 AS ErrorSeverity
					,1 AS ErrorState
					,1 AS ErrorProcedure
					,1 AS ErrorLine
					,'No es posible realizar la invitación. La persona posee una invitación' AS ErrorMessage
			RETURN 9999
			END

			IF(@Cant_Visitas_En_Mes >= 1  OR (MONTH(@Invitacion_Previa) = MONTH(@pFecha_Invitacion)) AND CONVERT(DATE, @Invitacion_Previa) <> '1900-01-01')
			BEGIN
				SELECT  5001 AS ErrorNumber
					,1 AS ErrorSeverity
					,1 AS ErrorState
					,1 AS ErrorProcedure
					,1 AS ErrorLine
					,'No es posible realizar la invitación. La persona ya fue invitada este mes.' AS ErrorMessage
			RETURN 9999
			END

			IF(@Invitacion_Previa <= @pFecha_Invitacion AND GETDATE() < @Invitacion_Previa AND CONVERT(DATE, @Invitacion_Previa) <> '1900-01-01')
			BEGIN
				SELECT  5001 AS ErrorNumber
					,1 AS ErrorSeverity
					,1 AS ErrorState
					,1 AS ErrorProcedure
					,1 AS ErrorLine
					,'No es posible realizar la invitación. La persona posee una invitación previa' AS ErrorMessage
			RETURN 9999
			END

			IF(@pFecha_Invitacion < CONVERT(VARCHAR(8),GETDATE(),112))
			BEGIN
				SELECT  5001 AS ErrorNumber
					,1 AS ErrorSeverity
					,1 AS ErrorState
					,1 AS ErrorProcedure
					,1 AS ErrorLine
					,'No es posible realizar la invitación.' AS ErrorMessage
			RETURN 9999
			END
		END

		IF (@pTipo = 1 /*INVITACION INDIVIDUAL*/)
		BEGIN
			INSERT INTO Clientes_Invitados_Mov (Id_Cliente,	Id_Cliente_D,	Fecha_Mov, Fecha, Id_Link)
			VALUES   (@pId_Invitante, @Existe, GETDATE(), @pFecha_Invitacion, @pId_Link)
		END

		IF (@pTipo = 2 /*GENERAR LINK (INVITACIONES MASIVAS)*/)
		BEGIN
			
			SET @Token = dbo.CF_Clientes_Links_Token('A',32)
			SET @URL = '/' + CONVERT(VARCHAR(20), 'invitados_link.php') + '/' + 'invitados_link.php?id=' + CONVERT(VARCHAR(250), @Token)


			INSERT INTO Clientes_Links (Url, Id_Cliente ,Fecha_Gen, Fecha_Ult_Uso, Cant_Usos_Permitidos,
										Cant_Usos_Realizados, Mail, Token, Nota, Fecha_Desde, Fecha_Hasta)
			VALUES					   (@URL, @pId_Invitante, GETDATE(), GETDATE(), @pCantidad, 
										0, '', @Token, @pObservacion, @pFecha_Invitacion, @pFecha_Invitacion)

			IF(@pId_Link <> 0)
			BEGIN
				UPDATE Clientes_Links SET Cant_Usos_Realizados = Cant_Usos_Realizados + 1 WHERE Id_Link = @pId_Link
			END
		END
	END
	ELSE
	BEGIN
			
		IF (@pTipo = 1 /*INVITACION INDIVIDUAL*/)
		BEGIN
				SET @Existe  = (SELECT MAX(Id_Cliente) FROM Clientes ) + 1

				INSERT INTO Clientes (Razon_Social,	  Apellido,			Nombre,			Id_Tipo_Doc,	Doc_Nro,
										Email,			  Email_Cob,		Email_Web,		Activo,			Id_Iva,
										Id_Tipo_Cli,	  Fecha_Alta,		Tipo_Persona,	Id_Cliente,		ID_NACIONALIDAD,
										ID_LISTA_PRECIO, Id_Cliente_Ref,	Observacion)

				VALUES (LTRIM(RTRIM(UPPER(@pApellido))) +' '+ LTRIM(RTRIM(UPPER(@pNombre))),UPPER(@pApellido),UPPER(@pNombre),'',@pDocumento,
						@pEmail,			@pEmail,			@pEmail,			1,				'CF',
						@Categoria_Invitado,				GETDATE(),			'F',			@Existe,		'ARG',
						0,					0,				@pObservacion )


				INSERT INTO Clientes_Invitados_Mov (Id_Cliente,	Id_Cliente_D,	Fecha_Mov, Fecha, Id_Link)
				VALUES   (@pId_Invitante, @Existe, GETDATE(), @pFecha_Invitacion, @pId_Link)

				IF(@pId_Link <> 0)
				BEGIN
					UPDATE Clientes_Links SET Cant_Usos_Realizados = Cant_Usos_Realizados + 1 WHERE Id_Link = @pId_Link
				END

				
			SELECT  0 AS ErrorNumber
					,0 AS ErrorSeverity
					,0 AS ErrorState
					,0 AS ErrorProcedure
					,0 AS ErrorLine
					,CAST(@Existe AS VARCHAR(4000)) AS ErrorMessage
			
		END

		IF (@pTipo = 2 /*GENERAR LINK (INVITACIONES MASIVAS)*/)
		BEGIN

			SET @Token = dbo.CF_Clientes_Links_Token('A',32)
			SET @URL = '/' + CONVERT(VARCHAR(25),'invitados_link.php?id=') + CONVERT(VARCHAR(250),@Token)

			INSERT INTO Clientes_Links (Url, Id_Cliente ,Fecha_Gen, Fecha_Ult_Uso, Cant_Usos_Permitidos,
										Cant_Usos_Realizados, Mail, Token, Nota, Fecha_Desde, Fecha_Hasta)
			VALUES					   (@URL, @pId_Invitante, GETDATE(), GETDATE(), @pCantidad, 
										0, '', @Token, @pObservacion, @pFecha_Invitacion, @pFecha_Invitacion)

			
			SELECT  0 AS ErrorNumber
					,0 AS ErrorSeverity
					,0 AS ErrorState
					,0 AS ErrorProcedure
					,0 AS ErrorLine
					,CAST(@URL AS VARCHAR(4000)) AS ErrorMessage
		END

	END

	/*====================================================================================================================================================*/

	IF @pFlagUsarTrans <> 0 COMMIT
	
	/*====================================================================================================================================================*/

	IF (@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Clientes_Visitas'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0  ROLLBACK

	RETURN 9999
END CATCH

RETURN 0 
